/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include "Context.h"
#include "Socket.h"
#include "IPAddress.h"

#include <memory>
#include <mutex>

class RemoteCommunication : Context
{
private:
	mutable std::mutex _receiveLock;
	mutable std::mutex _sendLock;
	bool connected = false;

public:
	std::uint32_t ReceiveBufferLen;
	std::unique_ptr<std::uint8_t[]> ReceiveBuffer;
	SOCKET Client;
	RemoteCommunication(Context* context);
	~RemoteCommunication();
	void Connect();
	void Disconnect() noexcept;
	bool IsConnected() const noexcept;
	std::int32_t Read();
	void Write(std::uint8_t* stream, std::size_t len);
};
